﻿using System;
using NetOffice;
using NetOffice.Attributes;
namespace NetOffice.WordApi.Enums
{
	 /// <summary>
	 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
	 /// </summary>
	 ///<remarks> MSDN Online Documentation: http://msdn.microsoft.com/en-us/en-us/library/office/ff836540.aspx </remarks>
	[SupportByVersion("Word", 9,10,11,12,14,15,16)]
	[EntityType(EntityType.IsEnum)]
	public enum WdWordDialog
	{
		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogHelpAbout = 9,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogHelpWordPerfectHelp = 10,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>511</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogHelpWordPerfectHelpOptions = 511,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>322</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatChangeCase = 322,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>790</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsFuzzy = 790,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>228</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsWordCount = 228,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>78</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogDocumentStatistics = 78,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>79</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileNew = 79,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>80</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileOpen = 80,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>81</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeOpenDataSource = 81,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>82</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeOpenHeaderSource = 82,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>779</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeUseAddressBook = 779,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>84</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileSaveAs = 84,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>86</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileSummaryInfo = 86,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>87</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsTemplates = 87,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>222</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogOrganizer = 222,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>88</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFilePrint = 88,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>676</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMerge = 676,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>677</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeCheck = 677,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>681</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeQueryOptions = 681,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>569</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeFindRecord = 569,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4049</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeInsertIf = 4049,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4053</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeInsertNextIf = 4053,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4055</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeInsertSkipIf = 4055,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4048</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeInsertFillIn = 4048,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4047</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeInsertAsk = 4047,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4054</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeInsertSet = 4054,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>680</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeHelper = 680,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>821</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogLetterWizard = 821,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>97</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFilePrintSetup = 97,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>99</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileFind = 99,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>642</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeCreateDataSource = 642,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>643</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMailMergeCreateHeaderSource = 643,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>111</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditPasteSpecial = 111,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>112</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditFind = 112,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>117</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditReplace = 117,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>811</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditGoToOld = 811,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>896</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditGoTo = 896,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>872</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogCreateAutoText = 872,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>985</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditAutoText = 985,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>124</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditLinks = 124,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>125</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditObject = 125,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>392</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogConvertObject = 392,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>128</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableToText = 128,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>127</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTextToTable = 127,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>129</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableInsertTable = 129,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>130</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableInsertCells = 130,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>131</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableInsertRow = 131,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>133</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableDeleteCells = 133,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>137</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableSplitCells = 137,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>348</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableFormula = 348,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>563</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableAutoFormat = 563,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>612</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableFormatCell = 612,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>577</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogViewZoom = 577,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>586</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogNewToolbar = 586,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>159</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertBreak = 159,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>370</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertFootnote = 370,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>162</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertSymbol = 162,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>163</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertPicture = 163,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>164</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertFile = 164,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>165</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertDateTime = 165,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>812</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertNumber = 812,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>166</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertField = 166,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>341</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertDatabase = 341,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>167</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertMergeField = 167,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>168</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertBookmark = 168,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>925</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertHyperlink = 925,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>169</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMarkIndexEntry = 169,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>463</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMarkCitation = 463,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>625</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditTOACategory = 625,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>473</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertIndexAndTables = 473,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>170</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertIndex = 170,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>171</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertTableOfContents = 171,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>442</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogMarkTableOfContentsEntry = 442,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>472</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertTableOfFigures = 472,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>471</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertTableOfAuthorities = 471,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>172</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertObject = 172,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>610</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatCallout = 610,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>633</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogDrawSnapToGrid = 633,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>634</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogDrawAlign = 634,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>607</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsEnvelopesAndLabels = 607,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>173</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCreateEnvelope = 173,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>489</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCreateLabels = 489,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>503</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsProtectDocument = 503,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>578</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsProtectSection = 578,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>521</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsUnprotectDocument = 521,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>174</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatFont = 174,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>175</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatParagraph = 175,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>176</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatSectionLayout = 176,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>177</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatColumns = 177,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>178</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileDocumentLayout = 178,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>685</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileMacPageSetup = 685,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>445</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFilePrintOneCopy = 445,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>444</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileMacPageSetupGX = 444,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>737</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileMacCustomPageSetupGX = 737,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>178</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFilePageSetup = 178,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>179</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatTabs = 179,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>180</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatStyle = 180,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>505</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatStyleGallery = 505,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>181</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDefineStyleFont = 181,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>182</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDefineStylePara = 182,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>183</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDefineStyleTabs = 183,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>184</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDefineStyleFrame = 184,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>185</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDefineStyleBorders = 185,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>186</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDefineStyleLang = 186,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>187</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatPicture = 187,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>188</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsLanguage = 188,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>189</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatBordersAndShading = 189,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>960</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDrawingObject = 960,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>190</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatFrame = 190,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>488</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatDropCap = 488,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>824</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatBulletsAndNumbering = 824,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>195</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsHyphenation = 195,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>196</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsBulletsNumbers = 196,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>197</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsHighlightChanges = 197,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>506</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsAcceptRejectChanges = 506,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>435</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsMergeDocuments = 435,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>198</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCompareDocuments = 198,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>199</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTableSort = 199,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>615</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCustomizeMenuBar = 615,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>152</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCustomize = 152,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>432</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCustomizeKeyboard = 432,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>433</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCustomizeMenus = 433,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>723</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogListCommands = 723,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>974</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptions = 974,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>203</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsGeneral = 203,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>206</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsAdvancedSettings = 206,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>525</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsCompatibility = 525,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>208</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsPrint = 208,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>209</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsSave = 209,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>211</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsSpellingAndGrammar = 211,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>828</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsSpellingAndGrammar = 828,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>194</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsThesaurus = 194,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>213</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsUserInfo = 213,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>959</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsAutoFormat = 959,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>386</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsTrackChanges = 386,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>224</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsEdit = 224,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>215</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsMacro = 215,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>294</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertPageNumbers = 294,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>298</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatPageNumber = 298,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>373</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogNoteOptions = 373,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>300</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogCopyFile = 300,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>103</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatAddrFonts = 103,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>221</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatRetAddrFonts = 221,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>225</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsFileLocations = 225,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>833</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsCreateDirectory = 833,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>331</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogUpdateTOC = 331,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>483</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertFormField = 483,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>353</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormFieldOptions = 353,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>357</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertCaption = 357,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>359</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertAutoCaption = 359,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>402</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertAddCaption = 402,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>358</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertCaptionNumbering = 358,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>367</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertCrossReference = 367,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>631</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsManageFields = 631,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>915</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsAutoManager = 915,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>378</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsAutoCorrect = 378,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>762</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsAutoCorrectExceptions = 762,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>420</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogConnect = 420,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1029</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsBidi = 1029,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>204</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsView = 204,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>583</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogInsertSubdocument = 583,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>624</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileRoutingSlip = 624,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>581</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFontSubstitution = 581,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>732</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditCreatePublisher = 732,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>733</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditSubscribeTo = 733,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>735</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditPublishOptions = 735,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>736</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEditSubscribeOptions = 736,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>739</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsTypography = 739,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>778</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsOptionsAutoFormatAsYouType = 778,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>235</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogControlRun = 235,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>945</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileVersions = 945,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>874</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsAutoSummarize = 874,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1007</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFileSaveVersion = 1007,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>220</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogWindowActivate = 220,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>214</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsMacroRecord = 214,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>197</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogToolsRevisions = 197,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>863</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogEmailOptions = 863,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>898</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogWebOptions = 898,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>983</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFitText = 983,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>986</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogPhoneticGuide = 986,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1160</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogHorizontalInVertical = 1160,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1161</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTwoLinesInOne = 1161,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1162</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatEncloseCharacters = 1162,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>855</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogFormatTheme = 855,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1156</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDialogTCSCTranslator = 1156,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>120</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogEditStyle = 120,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>142</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableRowHeight = 142,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>143</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableColumnWidth = 143,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>361</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogFormFieldHelp = 361,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>458</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogEditFrame = 458,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>470</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableOfContentsOptions = 470,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>551</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableOfCaptionsOptions = 551,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>570</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogReviewAfmtRevisions = 570,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>784</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogToolsHangulHanjaConversion = 784,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>854</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableWrapping = 854,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>861</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableProperties = 861,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>885</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogToolsGrammarSettings = 885,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>989</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogToolsDictionary = 989,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1074</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogFrameSetProperties = 1074,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1080</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableTableOptions = 1080,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1081</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogTableCellOptions = 1081,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1094</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogIMESetDefault = 1094,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1121</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogConsistencyChecker = 1121,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1395</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogToolsOptionsSmartTag = 1395,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1248</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogFormatStylesCustom = 1248,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1261</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogCSSLinks = 1261,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1324</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogInsertWebComponent = 1324,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1356</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogToolsOptionsEditCopyPaste = 1356,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1361</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogToolsOptionsSecurity = 1361,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1363</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogSearch = 1363,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1381</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogShowRepairs = 1381,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1304</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogMailMergeFieldMapping = 1304,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1305</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogMailMergeInsertAddressBlock = 1305,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1306</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogMailMergeInsertGreetingLine = 1306,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1307</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogMailMergeInsertFields = 1307,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1308</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogMailMergeRecipients = 1308,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1326</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogMailMergeFindRecipient = 1326,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1339</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDialogMailMergeSetDocumentType = 1339,

		 /// <summary>
		 /// SupportByVersion Word 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1460</remarks>
		 [SupportByVersion("Word", 11,12,14,15,16)]
		 wdDialogXMLElementAttributes = 1460,

		 /// <summary>
		 /// SupportByVersion Word 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1417</remarks>
		 [SupportByVersion("Word", 11,12,14,15,16)]
		 wdDialogSchemaLibrary = 1417,

		 /// <summary>
		 /// SupportByVersion Word 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1469</remarks>
		 [SupportByVersion("Word", 11,12,14,15,16)]
		 wdDialogPermission = 1469,

		 /// <summary>
		 /// SupportByVersion Word 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1437</remarks>
		 [SupportByVersion("Word", 11,12,14,15,16)]
		 wdDialogMyPermission = 1437,

		 /// <summary>
		 /// SupportByVersion Word 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1425</remarks>
		 [SupportByVersion("Word", 11,12,14,15,16)]
		 wdDialogXMLOptions = 1425,

		 /// <summary>
		 /// SupportByVersion Word 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1427</remarks>
		 [SupportByVersion("Word", 11,12,14,15,16)]
		 wdDialogFormattingRestrictions = 1427,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1367</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogLabelOptions = 1367,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1920</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogSourceManager = 1920,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1922</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogCreateSource = 1922,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1482</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogDocumentInspector = 1482,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1948</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogStyleManagement = 1948,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2120</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogInsertSource = 2120,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2165</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogOMathRecognizedFunctions = 2165,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2348</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogInsertPlaceholder = 2348,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2067</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogBuildingBlockOrganizer = 2067,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2394</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogContentControlProperties = 2394,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2439</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogCompatibilityChecker = 2439,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2349</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdDialogExportAsFixedFormat = 2349,

		 /// <summary>
		 /// SupportByVersion Word 14, 15, 16
		 /// </summary>
		 /// <remarks>1116</remarks>
		 [SupportByVersion("Word", 14,15,16)]
		 wdDialogFileNew2007 = 1116
	}
}